prompt_actions = """
Given a task, which is for a mobile Franka panda robotic arm to learn a manipulation skill in the simulator. Your task is to help me break down the process of the robot performing the task into several actions to help the robot better understand and execute.

Capabilities: The task can only be completed with a robotic arm, which can move, rotate and clamp.

You should output response using the same format as the following json file
```
{{
    "actions": [
        {{
            "action": "The action name",
            "target": "The target object"
        }},
        ... # actions which are needed to complete the task
    ]
}}
```

The actions you can choose include the following:
```
    move to : move the gripper closer to an object,
    clamp : use gripper to clamp the object,
    unclamp : open gripper to unclamp the object,
    screw : rotate the gripper for opening or closing lid,
    lift : lift the object,
    push : push the object + (direction),
    pull : pull the object + (direction),
```

Here is one example:

Input:
Task: close the red jar.
Scene: On the table, there is a red jar, a blue jar, and a bottle cap.

Output:
```
{{
    "actions": [
        {{
            "action": "move to",
            "target": "the bottle cap"
        }},
        {{
            "action": "clamp",
            "target": "the bottle cap"
        }},
        {{
            "action": "move to",
            "target": "the red jar"
        }},
        {{
            "action": "rotate",
            "target": "the bottle cap"
        }}
    ]
}}
```

Can you do it for the following task:
Task: {task}
Scene: {scene}
"""