import os
import json
def get_json_files(root_dir):
    json_files = []
    for root, dirs, files in os.walk(root_dir):
        for file in files:
            if file.endswith('.json'):
                file_path = os.path.join(root, file)
                # if check_labeled(file_path):
                json_files.append(file_path)
    return json_files

json_files = get_json_files('../dataset/miniF2F/informal/')
print(len(json_files))
# json_files = json_files[:1]

def remove_merge_conflicts(file_paths):
    for file_path in file_paths:
        last_line = ""
        
        with open(file_path, 'r+') as file:
            lines = file.readlines()
            file.seek(0)
            for line in lines:
                if '<<<<<<< HEAD' not in line and '>>>>>>> ' not in line and '=======' not in line:
                    file.write(line)
                    last_line = line
                    # print(line)
                if '=======' in line:
                    if last_line == "    ]\n":
                        # print("case 1")
                        file.write(",\n")
                        # print(last_line)
                    elif last_line == "        ]\n":
                        # print("case 2")
                        file.write("    },\n")
                        # print("    },")
                    else:
                        print(file_path)
                        print("case 3")
                        # file.write(line)
                        # print(line)
            file.truncate()

# Example usage
remove_merge_conflicts(json_files)

def check_json_syntax(file_paths):
    for file_path in file_paths:
        flag=False
        with open(file_path, 'r') as file:
            try:
                data = json.load(file)
                flag=True
                # print(f"{file_path} is a valid JSON file.")
            except json.JSONDecodeError as e:
                print(f"{file_path} is not a valid JSON file. Error: {str(e)}")
                flag=False
        if flag:
            with open(file_path, 'w') as file:  
                json.dump(data, file, indent=4)

# Example usage
check_json_syntax(json_files)