# Submission Code Guide

This submission code contains the final version of the Base size of our proposed model.

Below are the guidelines for training our model.

## 0. Python Version Requirement
- This code is compatible with Python version 3.10 and above.

## 1. Directory and File Structure
- The root directory consists of `data`, `models`, and `utils` directories, along with `run.py` and `run.sh` files.
- The `data` directory contains directories with `.scp` files that include data paths for the benchmark to be evaluated (e.g., `scp_ss_8k_wsj` for the WSJ dataset). The actual dataset is on the researcher's server, but to verify the executable code, WSJ training sample data are included in the `wsj_data` directory.
- The `utils` directory contains tools files related to datasets, engines, execution, and system operations.
- The `models` directory contains files related to the models to be used in the experiment (e.g., `models/SepReformer-wsj-base-e2d3-early-shared-cs-mlo`).

## 2. Model Setup
- In the directory of the model to be experimented with (e.g., `models/SepReformer-wsj-base-e2d3-early-shared-cs-mlo`), set the value of the `gpuid` key in the `engine` section of the `configs.yaml` file to the GPU device number to be used for training. Set the value of the `mode` key in the `engine` section to "train" if you want to train, or to "test" if you only want to test.

## 3. Using the Engine (Training or Testing) Code
- In the `run.sh` file in the root directory, set the `--model` argument to the name of the model directory in the `/models` directory for the experiment (e.g., `--model SepReformer-wsj-base-e2d3-early-shared-cs-mlo`).
- Run the code by typing `sh run.sh`.
