#!/bin/bash
export PYTHONPATH=/path/to/your/project
export CUDA_VISIBLE_DEVICES=2
result_path="/path/to/your/output"
#----------------------------------------
exp_name='exp_name_placeholder'
#----------------------------------------
model_name='model_placeholder' # use cache
#----------------------------------------
data_name="data_placeholder"
num_classes=10
#----------------------------------------
#model_path=${result_path}'/'${exp_name}'/models/model_ori.pth'
model_path='/path/to/your/model/file/model_int.pth'
#----------------------------------------
num_samples=50
data_dir='/path/to/your/dataset/train-m/'
save_dir='/path/to/your/output/features_int/'
#----------------------------------------
#cache_layers="10"
cache_layers="0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23"
#----------------------------------------
cache_types=(
  'x0'
  'c0'
  's0'
  'z0'
  'x1'
  'c1'
  's1'
  'z1'
  'h'
)
value_types=(
  'a'
  'g'
)
for value_type in ${value_types[*]}; do
  for cache_type in ${cache_types[*]}; do
    python core/feature_selection.py \
      --model_name ${model_name} \
      --data_name ${data_name} \
      --num_classes ${num_classes} \
      --model_path ${model_path} \
      --num_samples ${num_samples} \
      --cache_layers ${cache_layers} \
      --cache_type "${cache_type}" \
      --value_type "${value_type}" \
      --data_dir ${data_dir} \
      --save_dir ${save_dir}
  done
done
wait
echo "ACCOMPLISH ！！！"
