# @yaml
# signature: run_tests <path>
# docstring: runs all the tests in the specified path (only outputs failed tests)
run_tests() {
    if [ $# -lt 1 ] || [ $# -gt 2] ; then
        echo "Usage: run_tests <path to test file>"
        return
    fi

    test_path="$1"

    if [ ! -f "$test_path" ]; then
        echo "The given file does not exist: $test_path"
        return
    fi

    # Run all tests and only show information about failing ones in the output
    pytest -q -r vf --tb=no -p no:cacheprovider --maxfail=3 "$test_path"
}