import json
from pathlib import Path
import pandas as pd

def parse_hparam_name(hparam_dict, depth=0):
    ret_dict = dict()
    prefix = 'hps'
    for k, v in hparam_dict.items():
        if isinstance(v, dict):
            sub_dict = parse_hparam_name(v, depth+1)
            for sub_k, sub_v in sub_dict.items():
                new_k = prefix + '.' + k + '.' + sub_k
                ret_dict[new_k] = sub_v
        else:
            if depth > 0:
                new_k = k
            else:
                new_k = prefix + '.' + k
            ret_dict[new_k] = v
    return ret_dict

dataset_names = [
    'pd1_matched_phase0_results.jsonl',
    # 'pd1_matched_phase1_results.jsonl',
    # 'pd1_unmatched_phase0_results.jsonl',
    # 'pd1_unmatched_phase1_results.jsonl',
]

for dataset_name in dataset_names:
    path = '{}/dataset/pd1/{}'.format(Path.home(), dataset_name)
    with open(path, 'r') as fin:
        df = pd.read_json(fin, orient='records', lines=True)

    ret_dict = parse_hparam_name(df['hparams'][0])
    print(ret_dict)
    print(df.columns)
    for k in ret_dict.keys():
        assert k in df.columns