import re
import numpy as np

from typing import Any, Dict, List

from symbolic_compiler.utils.utils import match_and_remove_first_occurrence
# from symbolic_compiler.data_structs.ner_example import NERExample

class AutoDsl:
    def __init__(self, data:dict):
        self.data = data
        self.action_list = list(self.data.keys())
        self.paramter_list = []
        self.label_mapping = {
            "REG": "reagent",
            "Container":"container",
            "Device":"device",
            "Time":"time",
            "Temperature":"temperature",
            "Mass":"mass",
            "Speed":"speed",
            "Concentration":"concentration",
            "Volume":"volume",
            "Length":"length",
            "String":"string",
            "Force":"force",
            "Bool":"bool",
            "Voltage":"voltage",
            "Frequency":"frequency"
        }
        self.__prepare_data()

    def __prepare_data(self):
        params = set()
        for action in self.data:
            pattern_list = self.data[action]
            for pattern in pattern_list:
                pattern_format = pattern["pattern"]
                for param in pattern_format:
                    params.add(self.label_mapping[param])
        self.paramter_list = list(params)
        self.paramter_list.append("output")

    # def NER_examples(self) -> List[NERExample]:
    #     example_list = []
    #     for action in self.data:
    #         pattern_list = self.data[action]
    #         for pattern in pattern_list:
    #             pattern_examples = pattern["example"]
    #             for example in pattern_examples:
    #                 example_list.append(example)
        
    #     NER_example_list = []
    #     for example in example_list:
    #         origin, label = self.__check_annotated_format(example)
    #         entity = re.sub(r'{[^}]*}', '', example)
    #         named_entity = str([{a:b} for a, b in zip(origin, label)])
    #         NER_example_list.append(NERExample(entity, named_entity))
    #     return NER_example_list
    
    def __check_annotated_format(self, annotated_corpora):
        annotated_corpora = annotated_corpora[:]
        origin = re.findall(r'\[([^[\]]*)\]', annotated_corpora)
        label = re.findall(r'\{([^}]*)\}', annotated_corpora)
        origin_indexs, delete_char_num = [], 0
        for ori in origin:
            index, annotated_corpora = match_and_remove_first_occurrence(annotated_corpora, ori)
            origin_indexs.append(index + delete_char_num)
            if index != -1:
                delete_char_num += len(ori)
        for lab in label:
            _, annotated_corpora = match_and_remove_first_occurrence(annotated_corpora, lab)
        return origin, label
    
    def get_format(self, action):
        if action not in self.action_list:
            raise "wrong action"
        else:
            return self.data[action]

