# Constraint_Decoding

## Enviorment Setup

```
export OPENAI_API_KEY="your OPENAI key"
conda create -n compiler python==3.8
conda activate compiler
pip install -r requirements.txt
python preprocess_data.py
```

## DSL Program Generation

Please unzip `llm_cache` and copy it along with `llm_embedding` into the root directory of this project.

Execute the following command, and you will obtain the translation results of ConDec-SY in the `results` folder.

```
python main.py \
    --mode testset \
    --seed 1 \
    --cut_len 5 \
    --dataset testset \
    --num_shot -1 \
    --batch_size 4 \
    --engine openai/gpt-3.5-turbo \
    --temperature 0.0 \
    --max_tokens 2048 \
    --prompt_mode rot \
    --prompt_template wrule \
    --retrieve_fn bm25 \
    --add_rule_instruction_flag \
    --constrain_prog_gen_flag \
    --constrain_rule_gen_flag \
    --use_action_list_flag \
    --add_rule_list_flag
```

It should be consistent with the corresponding algorithm output in the `AutoDSL-Translation-Resources/results/program_output` folder.