function[f_vec,g_vec,time_vec,x] = R_APM(fun_f,grad_f,grad_g,fun_g,param,x0)


eta = 1/(param.maxiter+1);
gamma = 1/(2*param.L_g);
lambda=param.lam;

f_vec = [];
g_vec = [];
time_vec = [];
acc_vec = [];
x = x0;
y = x0;
t = 1;

%% algorithm
maxiter = param.maxiter;
maxtime = param.maxtime;
tic;
cpu_t = 0;
for k = 1 : maxiter 
% while cpu_t < maxtime
    x_prev = x;
    % Descent step
    x = y - gamma*(grad_g(y)+eta*grad_f(y));
    % Projection step
%     x = ProjectOntoL1Ball(x,lambda);
%     x = ProjectOntoL2Ball0(x,lambda);
    x = ProjectOntoRn_Plus(x);
    t_prev = t;
    t = 0.5 + sqrt(0.25+t^2);
    y = x + (t_prev-1)*(x-x_prev)/t;
    

%     eta_k = (eta_0)/(k+1)^0.25;
%     gamma_k = gamma_0/sqrt(k+1);
%     % Descent step
%     x = x - gamma_k*(grad_g(x)+eta_k*(grad_f(x)));
%     % Projection step
%     x = ProjectOntoL1Ball(x,lambda);    
    cpu_t = toc;
    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec;cpu_t];
    % test set accuracy
%     acc_vec = [acc_vec;TSA(x)];
    if cpu_t>maxtime
        break
    end
end