# Causal Amortized Structure Learning (CAASL)

This repository holds the implementation code for the submission  **Amortized Active Causal Induction with Deep Reinforcement Learning**.

This code is based on RL for SED by Blau et al. 2022 with the [open source code](https://github.com/csiro-mlai/RL-BOED) and [MIT License](https://github.com/csiro-mlai/RL-BOED?tab=MIT-1-ov-file#readme)

# Installation 

This code has been tested in Python 3.10.13. 

Installation is done using `conda`:

````
conda create -n "caasl" python=3.10.13
conda activate caasl
pip install -r requirements.txt
````

Then go to the `garage` directory and install it

````
cd garage/
pip install -e .
````

## RL Experiments

Here are the commands for runnning the model on the best hyperaparameters reported in Appendix. We recommend having atleast 100 GB of GPU memory. The code can run on multiple-gpus in a data parallel fashion.

For  Linear Gaussian SCM with SAC

```
$ python -m Experiments.LinGaussSEM_SAC  --n-rl-itr=10001 --bound-type="ba" --d=10 --budget=10 --discount=0.9 \
 --buffer-capacity=10000000 --tau=0.001 --pi-lr=0.001 --qf-lr=0.00003 --ens-size=5 --n-parallel 1000 --G 1 \
 --wandb --num-attn-layers 4 --num-attn-layers-q-func 4  --graph-degree=3.0 
```

For SERGIO simulator:

````
python -m Experiments.Sergio_SAC  --n-rl-itr=10001 --d=10 --budget=10 --discount=0.95 \
 --buffer-capacity=1000000 --tau=0.001 --pi-lr=0.01 --qf-lr=0.000003 --ens-size=5 --n-parallel 1000 --G 1 \
 --wandb --num-attn-layers 3 --num-attn-layers-q-func 3  --graph-degree=3.0 
````

