class Gaussian(object):
    def __init__(self, scale=1.0):
        self.scale = scale

    def __call__(self, rng, shape=None):
        return self.scale * rng.normal(size=shape)


class Laplace(object):
    def __init__(self, scale=1):
        self.scale = scale

    def __call__(self, rng, shape=None):
        return self.scale * rng.laplace(size=shape)


class Uniform(object):
    def __init__(self, low, high):
        self.low = low
        self.high = high

    def __call__(self, rng, shape=None):
        return rng.uniform(size=shape, low=self.low, high=self.high)


class RandInt(object):
    def __init__(self, low, high, endpoint=True):
        self.low = low
        self.high = high
        self.endpoint = endpoint

    def __call__(self, rng, shape=None):
        return rng.integers(
            size=shape, low=self.low, high=self.high, endpoint=self.endpoint
        )


class Beta(object):
    def __init__(self, a, b):
        self.a = a
        self.b = b

    def __call__(self, rng, shape=None):
        return rng.beta(self.a, self.b, size=shape)
