
from os.path import dirname, realpath
import sys
filepath = realpath(".")

dir_of_file = dirname(filepath)
parent_dir_of_file = dirname(dir_of_file)
parents_parent_dir_of_file = dirname(parent_dir_of_file)
p_parents_parent_dir_of_file = dirname(parents_parent_dir_of_file)
print(p_parents_parent_dir_of_file)
sys.path.insert(1, f'{p_parents_parent_dir_of_file}')

from all_functions import * 
import argparse
import time
import glob
import os

def main(args):
    all_files = glob.glob(args.datapath+"/*")
    only_portfolios = [f for f in all_files if "portfolios" in f]
    for portfolio_file in only_portfolios:
        with open(portfolio_file,"rb") as handle:
                fname = os.path.basename(portfolio_file)

                data = pickle.load(handle)
                samples = data['data']
                portfolios = data["portfolios"]
                copula_portfolios = data['copula_portfolios']

                portfolio_time = []
                all_tests_portfolio = []
                for p in portfolios:
                    start = time.time()
                    all_tests_portfolio.append(get_testing(p))
                    end = time.time()
                    exec_time = end-start
                    portfolio_time.append(exec_time)


                copula_portfolio_time = []
                all_tests_copula_portfolio = []
                for p in copula_portfolios:
                    start = time.time()
                    all_tests_copula_portfolio.append(get_testing(p))
                    end = time.time()
                    exec_time = end-start
                    copula_portfolio_time.append(exec_time)


                op = {}

                op['rel_testing'] = {"portfolio":all_tests_portfolio, \
                                    "copula_portfolio": all_tests_copula_portfolio}

                with open(fname+"_all_testing", 'wb') as handle:
                    pickle.dump(op, handle, protocol=pickle.HIGHEST_PROTOCOL)

                timing = {}

                timing['portfolio_testing'] = portfolio_time
                timing['copula_portfolio_testing'] = copula_portfolio_time


                with open(fname+"_all_timing", 'wb') as handle:
                    pickle.dump(timing, handle, protocol=pickle.HIGHEST_PROTOCOL)

    return 


















if __name__ == "__main__":    
    
    parser = argparse.ArgumentParser(description='Sample Based Ranks Script')
    parser.add_argument('--datapath', help='Pickle path')
    args = parser.parse_args()
    main(args)
    