import os
from os.path import basename
import math
import argparse
import random
import logging
import cv2
import sys
import numpy as np
import torch
import torchvision.transforms.functional as TF
from PIL import Image
import options.options as option
from utils import util
import torchvision.transforms as T
import lpips
import model as Model
import core.logger as Logger
import core.metrics as Metrics


to_tensor = T.ToTensor()
to_cv2_image = lambda x: np.array(T.ToPILImage()(torch.clip(x, 0, 1)))

from torchvision import transforms
transform = transforms.Lambda(lambda t: (t * 2) - 1)

def getEnv(name): import os; return True if name in os.environ.keys() else False

def t(array): return torch.Tensor(np.expand_dims(array.transpose([2, 0, 1]), axis=0).astype(np.float32)) / 255

def rgb(t): return (
        np.clip((t[0] if len(t.shape) == 4 else t).detach().cpu().numpy().transpose([1, 2, 0]), 0, 1) * 255).astype(
    np.uint8)

def cropimage(lr):
    h = int(lr.shape[2]/32)
    w = int(lr.shape[3]/32)
    lr = lr[:,:,int((lr.shape[2]-h*32)/2):int(lr.shape[2]-(lr.shape[2]-h*32)/2), int((lr.shape[3]-w*32)/2):int(lr.shape[3]-(lr.shape[3]-w*32)/2)]
    return lr


transform = transforms.Lambda(lambda t: (t * 2) - 1)

def main():
    #### options
    parser = argparse.ArgumentParser()
    parser = argparse.ArgumentParser()
    parser.add_argument('--dataset', type=str, help='Path to option YMAL file.',
                            default='./config/LOLv2.yml') # 
    parser.add_argument('--input', type=str, help='testing the unpaired image',
                            default='images/unpaired/input.png')
    parser.add_argument('--launcher', choices=['none', 'pytorch'], default='none',
                        help='job launcher')
    parser.add_argument('--local_rank', type=int, default=0)
    parser.add_argument('--tfboard', action='store_true')


    parser.add_argument('-c', '--config', type=str, default='config/llie_diffusion_test.json',
                        help='JSON file for configuration')
    parser.add_argument('-p', '--phase', type=str, choices=['train', 'val'],
                        help='Run either train(training) or val(generation)', default='train')
    parser.add_argument('-gpu', '--gpu_ids', type=str, default="0")
    parser.add_argument('-debug', '-d', action='store_true')
    parser.add_argument('-enable_wandb', action='store_true')
    parser.add_argument('-log_wandb_ckpt', action='store_true')
    parser.add_argument('-log_eval', action='store_true')

    # parse configs
    args = parser.parse_args()
    opt = Logger.parse(args)
    # Convert to NoneDict, which return None for missing key.
    opt = Logger.dict_to_nonedict(opt)

    os.environ['CUDA_VISIBLE_DEVICES'] = '0'

    opt['phase'] = 'test'

    #### distributed training settings
    opt['dist'] = False
    rank = -1
    print('Disabled distributed training.')

    #### mkdir and loggers
    if rank <= 0:  # normal training (rank -1) OR distributed training (rank 0)
        # config loggers. Before it, the log will not work
        util.setup_logger('val', opt['path']['log'], 'val_' + opt['name'], level=logging.INFO,
                          screen=True, tofile=True)
        logger = logging.getLogger('base')
        logger.info(option.dict2str(opt))


    util.setup_logger('base', opt['path']['log'], 'train', level=logging.INFO, screen=True)
    logger = logging.getLogger('base')

    # convert to NoneDict, which returns None for missing keys
    opt = option.dict_to_nonedict(opt)

    #### random seed
    seed = opt['train']['manual_seed']
    if seed is None:
        seed = random.randint(1, 10000)
        # seed = 1965
    if rank <= 0:
        logger.info('Random seed: {}'.format(seed))
    util.set_random_seed(seed)

    torch.backends.cudnn.benchmark = True
    # torch.backends.cudnn.deterministic = True


    # model
    diffusion = Model.create_model(opt)
    logger.info('Initial Model Finished')

    result_path = '{}'.format(opt['path']['results'])
    os.makedirs(result_path, exist_ok=True)

    diffusion.set_new_noise_schedule(
        opt['model']['beta_schedule']['val'], schedule_phase='val')

    path = args.input
    img = Image.open(path).convert('RGB')
    input = transform(TF.to_tensor(img)).unsqueeze(0).cuda()


    idx = 1
    val_data = {}
    val_data['LQ'] = cropimage(input)
    val_data['GT'] = cropimage(input)
    diffusion.feed_data(val_data)
    diffusion.test(continous=False)

    visuals = diffusion.get_current_visuals()
    
    normal_img = Metrics.tensor2img(visuals['HQ'])  
    ll_img = Metrics.tensor2img(visuals['LQ']) 

    llie_img_mode = 'single'
    if llie_img_mode == 'single':
        util.save_img(
            ll_img, '{}/{}_input.png'.format(result_path, idx))
        util.save_img(
            normal_img, '{}/{}_normal.png'.format(result_path, idx))
    else:
        util.save_img(
            normal_img, '{}/{}_{}_normal_process.png'.format(result_path, idx))
        util.save_img(
            Metrics.tensor2img(visuals['HQ'][-1]), '{}/{}_normal.png'.format(result_path, idx))
        normal_img = Metrics.tensor2img(visuals['HQ'][-1])





if __name__ == '__main__':
    main()
