# N-body MNIST
Code is adopted from the [official Earthformer project](https://github.com/amazon-science/earth-forecasting-transformer/tree/cfb6e6f43eb4e172226477699113a06248d89c26/scripts/datasets/nbody).

The underlying dynamics in the N-body MNIST dataset is governed by the Newton's law of universal gravitation:

$\frac{d^2\boldsymbol{x}\_{i}}{dt^2} = - \sum\_{j\neq i}\frac{G m\_j (\boldsymbol{x}\_{i}-\boldsymbol{x}\_{j})}{(\|\boldsymbol{x}\_i-\boldsymbol{x}\_j\|+d\_{\text{soft}})^r}$

where $\boldsymbol{x}\_{i}$ is the spatial coordinates of the $i$-th digit, $G$ is the gravitational constant, $m\_j$ is the mass of the $j$-th digit, $r$ is a constant representing the power scale in the gravitational law, $d\_{\text{soft}}$ is a small softening distance that ensures numerical stability.

Run the following commands to generate N-body MNIST dataset.
```bash
cd ROOT_DIR/prediff
python ./scripts/nbody_datasets/generate_nbody_dataset.py --cfg ./scripts/nbody_dataset/cfg.yaml
```
