################################ Description ########################################################
# This function generates dataset with time-fixed covariates, each covariate
### follows the same distribution of that of the first pseudosubject generated by 
### the time-varying generation function.
#####################################################################################################
itct_term_tfnPH <- function(beta,x1,x2,x3,x4,x5,x6){
  R1 = x1*x2-log(x3+x4)-x6/x5
  R2 = -beta[1]*x1-beta[2]*x2-beta[3]*x3-beta[4]*x4-beta[5]*x5-beta[6]*x6
  R3 = cos(pi*(x1+x5))+sqrt(x6+x2)-x3 #cos(x1+x3+x5+x6+x4+x2)
  R4 = beta[1]*x1+beta[2]*x2+beta[3]*x3+beta[4]*x4+beta[5]*x5+beta[6]*x6
  R0 = (x4>=0.7)*((x5==5))*R1+(x4>=0.7)*(1-(x5==5))*R3+
    (x4<0.7)*((x5==5))*R2 + (x4<0.7)*(1-(x5==5))*R4
  return(R0)
}
#####################======== Large number of pseudo-subjects ===============#####################
TimeindepLTRC_gnrt_nonPH <- function(N = 200, model = 1, censor.rate = 1, Distibution = "WI"){
  Nadd = N * 0.20
  N = Nadd + N
  Data <- as.data.frame(matrix(NA, N, 28))
  names(Data)<-c("I","ID","X1","X2","X3","X4","X5","X6","X7","X8","X9","X10", 
                 "X11","X12","X13","X14","X15","X16","X17","X18","X19","X20",
                 "Start","Stop","C","Event","Xi","Fstar")
  ## time-invariant
  Data$X1 <- sample(c(0,1),N,replace=TRUE)
  Data$X2 <- runif(N,0,1)
  Data$X3 <- sample(c(0,1),N,replace=TRUE)
  Data$X4 <- runif(N,0,1)
  Data$X5 <- sample(c(1:5),N,replace = TRUE)
  Data$X6 <- 2
  Data$X7 <- runif(N,0,1)
  Data$X8 <- runif(N,1,2)
  Data$X9 <- sample(c(1:5),N,replace=TRUE)
  Data$X10 <- runif(N,0,1)
  Data$X11 <- sample(c(0,1),N,replace=TRUE)
  Data$X12 <- sample(c(0,1,2),N,replace=TRUE)
  ## time-varying 
  Data$X14 <- sample(c(1:5),N,replace = TRUE)
  Data$X15 <- runif(N,0,1)
  Data$X17 <- runif(N,0,1)
  Data$X19 <- sample(c(0,1),N,replace=TRUE) 
  Data$X6 = sample(c(0,1,2),N,replace=TRUE)
  Data$X13 = sample(c(0,1),N,replace=TRUE) 
  Data$X16 = sample(c(0,1),N,replace=TRUE) 
  Data$X18 <- sample(c(0,1,2),N,replace=TRUE)
  Data$X20 <- runif(N)
  Data$U <- runif(N)
  if (model == 4){
    Beta <- c(1,1,1,1,10,1)
    Data$Fstar <- sapply(1:N, function(Ni) {itct_term_tfnPH(beta=Beta,Data$X1[Ni],Data$X2[Ni],Data$X3[Ni],Data$X4[Ni],Data$X5[Ni],Data$X6[Ni])})
    Lambda = 0.001
    truncation = 100
  } else if (model == 2){
    Beta <- c(1,1,1,1,10,1)
    Data$Fstar <- Beta[1]*Data$X1+Beta[2]*Data$X2+Beta[3]*Data$X3+
      Beta[4]*Data$X4+Beta[5]*Data$X5+Beta[6]*Data$X6
    Lambda = 0.001
    truncation = 100
  } else if (model == 3){
    Data$Fstar <- cos(Data$X1+Data$X3+Data$X5+Data$X6+Data$X4+Data$X2)
    Lambda = 0.002
    truncation = 100
  } else {
    stop("Wrong model type is given.")
  }
  
  Data$Fstar = (Data$Fstar - min(Data$Fstar)+0.005)/diff(range(Data$Fstar))*3
  
  Data$Xi <- exp(Data$Fstar)
  
  TT = -log(Data$U)
  TT = (TT/(Lambda^Data$Xi))^(1/Data$Xi)
  
  Data$Stop <- TT
  Data$Start <- 0
  Data$C <- 0
  Data$Event <- 1
  
  ## only adjusted for censor.rate = 1
  if (model == 4){
    if(censor.rate == 0){
      Censor.time <- rep(Inf,N)
    }else if(censor.rate == 1){
      Censor.time = rexp(N,rate = 1/4080)
    }else if(censor.rate == 2){
      Censor.time = rexp(N,rate = 1/230)
    }else{
      stop("Wrong censoring type")
    }
  } else if (model == 2){
    if(censor.rate == 0){
      Censor.time <- rep(Inf,N)
    }else if(censor.rate == 1){
      Censor.time = rexp(N,rate = 1/4220)
    }else if(censor.rate == 2){
      Censor.time = rexp(N,rate = 1/177)
    }else{
      stop("Wrong censoring type")
    }
  } else if (model == 3){
    if(censor.rate == 0){
      Censor.time <- rep(Inf,N)
    }else if(censor.rate == 1){
      Censor.time = rexp(N,rate = 1/2100)
    }else if(censor.rate == 2){
      Censor.time = rexp(N,rate = 1/220)
    }else{
      stop("Wrong censoring type.")
    }
  } else {
    stop("Wrong model type.")
  }
  
  
  for( j in 1:N){
    Vec <- c(0,Data[j,]$Stop,Inf)
    ID <- findInterval(Censor.time[j], Vec)
    
    if (ID <= 1){
      Data[j,][ID,]$C = 1
      Data[j,][ID,]$Event = 0
      Data[j,][ID,]$Stop = Censor.time[j]
    }
  }
  
  L = runif(N, 0, truncation)
  idx = which(Data$Stop > L)
  Data$Start = L
  
  
  N = N - Nadd
  Data = Data[idx[1:N], ]
  Data$I <- 1:nrow(Data)
  Data$ID <- 1:nrow(Data)
  RET <- NULL
  RET$Data <- Data
  Coeff <- NULL
  Coeff$Lambda <- Lambda
  RET$Info = list(Coeff = Coeff, Dist = "WI", Set = "nonPH")
  return(RET)
}

