from tqdm import auto as tqdm_lib


class EmptyTqdm:
    """
    Dummy tqdm which doesn't do anything.
    """

    def __init__(self, *args, **kwargs):  # pylint: disable=unused-argument
        self._iterator = args[0] if args else None

    def __iter__(self):
        return iter(self._iterator)

    def __getattr__(self, _):
        """
        Return empty function.
        """

        def empty_fn(*args, **kwargs):  # pylint: disable=unused-argument
            return

        return empty_fn

    def __enter__(self):
        return self

    def __exit__(self, type_, value, traceback):
        return


_tqdm_active = True


class _tqdm_cls:
    def __call__(self, *args, **kwargs):
        if _tqdm_active:
            return tqdm_lib.tqdm(*args, **kwargs)
        else:
            return EmptyTqdm(*args, **kwargs)

    def set_lock(self, *args, **kwargs):
        self._lock = None
        if _tqdm_active:
            return tqdm_lib.tqdm.set_lock(*args, **kwargs)

    def get_lock(self):
        if _tqdm_active:
            return tqdm_lib.tqdm.get_lock()


tqdm = _tqdm_cls()


def is_progress_bar_enabled() -> bool:
    """
    Return a boolean indicating whether tqdm progress bars are enabled.
    """
    global _tqdm_active
    return bool(_tqdm_active)


def enable_progress_bar():
    """
    Enable tqdm progress bar.
    """
    global _tqdm_active
    _tqdm_active = True


def disable_progress_bar():
    """
    Disable tqdm progress bar.
    """
    global _tqdm_active
    _tqdm_active = False
