function Example = LRRS_Gaussian_rank1_noisy_def()
%LRRS_Gaussian_phasetransition_def This function defines the problem
%parameters of a simple experiment for low-rank and row-sparse matrix
%recovery from dense Gaussian measurements
descr = 'LRRS_Gaussian_rank1_noisy_n2_40';
%% Choose problem parameters
prob = struct;

prob.n1 = 256; % number of rows
prob.n2 = 40; % number of columns
prob.K1 = 40; % row sparsity of ground truth
prob.r  = 1;  % rank of ground truth
prob.modeX0  = 1; % mode for creation of ground truth
prob.complex = 0; % boolean determining whether ground truth is complex or not
prob.add_noise = true;
prob.SNR = 1e2;
%%% choose graph shift matrix model. See "createGraphShiftOperator.m" for
%%% all relevant options.
% prob.graphmodel = struct;
% prob.graphmodel.type = 'community';%'swissroll'
% prob.graphmodel.r = 20;
% prob.graphmodel.rankcutoff = true;
% prob.graphmodel.communitytype = 4;
% prob.normalization = 'randomwalk';% choose as 'degrees_symmetric', 'randomwalk' or false  %(cf. "normalize_GraphMatrix.m" to see what this does)
% prob.heatdiffusion.flag = false; %or: prob.heatdiffusion.flag = true and prob.heatdiffusion.tau = ... for time parameter.
% % prob.heatdiffusion.tau = 0.5;
% prob.operatorHermitian = false; % choose if we work on the set of symmetric/Hermitian matrices not.
% prob.powers = [1:7]; % defines which matrix powers of graph shift operator to be considered


%% Choose sampling scheme
samplemodel = struct; % Check docu of "run_methods_Completion.m" for 
samplemodel.mode =  'Gaussian_dense';%'random_adaptive_probs';%'random_fully_uniform';%'random_adaptive_probs';%'random_fully_uniform';% Or: 'random_adaptive_probs', 'random_fully_uniform', 'random_fixed_sensors'
% samplemodel.samplingHermitian = false; % needs to be chose as true if 'prob.operatorHermitian == true'. If true, use symmetric sampling model.

% samplemodel.l = floor(1.*length(prob.powers));

samplemodel.oversampling = 3.0;

samplemodel = prepare_samplemodel_LRRS(prob,samplemodel);

%% Choose coherence computation and plotting parameters
% (Can take a lot of computational ressources if used, so don't calculate
% things that are not needed)
optsfct = struct;
% optsfct.calcincoherence = 'T';%'T'; % cf. docu of "run_methods_Completion.m" of how to adapt this
% optsfct.calcmatrices   = true;%true; % if true, calculate and store block Hankel matrices explicitly, e.g., of ground truth.
optsfct.plot = struct;
% optsfct.plot.sampling           = true;
optsfct.plot.errors                 = true; %_shiftmatrix = false;
optsfct.plot.timing                 = true;
% optsfct.plot.summary            = false;
% optsfct.plot.support            = false;
% optsfct.plot.incoherences       = false;
optsfct.plot.input              = true;
optsfct.verbose = true;
%% Choose algorithmic parameters
alg_name = {'IRLS-LRRS','SparsePowerFactorization','RiemannianIHT_adap'};%'SparsePowerFactorization','RiemannianIHT_adap','SparsePowerFactorization','RiemannianIHT_adap',''ATLAS','SparsePowerFactorization'};

opts = struct;
opts.rankpara      = prob.r; % rank parameter used as an input for reconstruction algorithm. Should be equal to the rank of ground truth for best results.
opts.rowspara      = prob.K1; % sparsity parameter for group sparsity used as input for reconstruction algorithm.
opts.verbose       = 2;
opts.K1          = prob.K1;
opts.r           = prob.r;
opts.N0          = 250; % max. number of outer IRLS iterations
opts.N0_inner    = 100; % max. number of inner IRLS iterations in algorithm
opts.N0_firstorder = 2000;
opts.tol_CG      = 1e-13;
opts.tol         = 1e-10;
opts.lambdarange = 1;
opts.mu          = 0;
opts.saveiterates = 1;
opts.epschoice = 'independent';
opts.lrproject_output = false;
opts.stop_threshvals = true;

opts.mode = 'full';   % for IRLS-LRRS; alternative:  mode = 'CG';
%opts.saveiterates = 1;
%opts.pencil_para = 4; % specify pencil parameter if desired. By default, square pencil parameter will be chosen.
%opts.decomposition = 'svdexact';

Example = zipExample(descr,prob,samplemodel,optsfct,opts,alg_name);
end

