#FourierGNN
FourierGNN: Rethinking Multivariate Time Series Forecasting from a Pure Graph Perspective


###Datasets
Due to limitations on upload file size, we only put some datasets (ECG, COVID-19, METR-LA, and Traffic) in the data directory.
The datasets can be downloaded from the corresponding websites.
1. Solar https://www.nrel.gov/grid/solar-power-data.html: This dataset is about the solar power collected by National Renewable Energy Laboratory. We choose the power plant data points in Florida as the data set which contains 593 points. The data is collected from 2006/01/01 to 2016/12/31 with the sampling interval of every 1 hour.

2. Wiki https://www.kaggle.com/c/web-traffic-time-series-forecasting/data: This dataset contains a number of daily views of different Wikipedia articles and is collected from 2015/7/1 to 2016/12/31. It consists of approximately 145k time series and we randomly choose 2k from them as our experimental data set.

3. Traffic https://archive.ics.uci.edu/ml/datasets/PEMS-SF: This dataset contains hourly traffic data from 963 San Francisco freeway car lanes. The traffic data are collected since 2015/01/01 with the sampling interval of every 1 hour.

4. ECG http://www.timeseriesclassification.com/description.php?Dataset=ECG5000: This dataset is about Electrocardiogram(ECG) from the UCR time-series classification
archive. It contains 140 nodes and each node has a length of 5000.

5. Electricity https://archive.ics.uci.edu/ml/datasets/ElectricityLoadDiagrams20112014: This dataset contains electricity consumption of 370 clients and is collected since 2011/01/01. Data sampling interval is every 15 minutes.

6. COVID-19 https://github.com/CSSEGISandData/COVID-19: This dataset is about COVID-19 hospitalization in the U.S. states of California (CA) from 01/02/2020 to 31/12/2020 provided by the Johns Hopkins University with the sampling interval of every one day.

7. METR-LA https://github.com/liyaguang/DCRNN: This dataset contains traffic information collected from loop detectors in the highway of Los Angeles County. It contains 207 sensors which is from 01/03/2012 to 30/06/2012 and the data sampling interval is every 5 minutes.

###Baselines
1. DeepGLO: https://github.com/rajatsen91/deepglo
2. LSTNet: https://github.com/laiguokun/LSTNet
3. TCN: https://github.com/locuslab/TCN
4. Reformer: https://github.com/thuml/Autoformer
5. Informer: https://github.com/zhouhaoyi/Informer2020
6. Autoformer: https://github.com/thuml/Autoformer
7. FEDformer: https://github.com/MAZiqing/FEDformer
8. SFM: https://github.com/z331565360/State-Frequency-Memory-stock-prediction
9. StemGNN: https://github.com/microsoft/StemGNN
10. MTGNN: https://github.com/nnzhan/MTGNN
11. GraphWaveNet: https://github.com/nnzhan/Graph-WaveNet
12. AGCRN: https://github.com/LeiBAI/AGCRN
13. TAMP-S2GCNets: https://www.dropbox.com/sh/n0ajd5l0tdeyb80/AABGn-ejfV1YtRwjf_L0AOsNa?dl=0
14. DCRNN: https://github.com/liyaguang/DCRNN
15. STGCN: https://github.com/VeritasYin/STGCN_IJCAI-18
16. CoST: https://github.com/salesforce/CoST

### Running the Codes
`python main.py`

- Covid: -- feature_size 55 -- embedding size 256 -- hidden size 512 -- batch size 4 --train_ratio 0.6 --val_ratio 0.2
- METR-LA: -- feature_size 207 -- embedding size 128 -- hidden size 256 -- batch size 32 --train_ratio 0.7 --val_ratio 0.2
- Traffic: feature_size 963 -- hidden size 128 -- hidden size 256 -- batch size 2 --train_ratio 0.7 --val_ratio 0.2
- ECG: feature_size 140  -- hidden size 128 -- hidden size 256 -- batch size  4 --train_ratio 0.7 --val_ratio 0.2
- Solar: feature_size 592 -- hidden size 128 -- hidden size 256 -- batch size 2 --train_ratio 0.7 --val_ratio 0.2
- Wiki: feature_size 2000 -- hidden size 128 -- hidden size 256 -- batch size 2 --train_ratio 0.7 --val_ratio 0.2
- Electricity: feature_size 370 -- hidden size 128 -- hidden size 256 -- batch size 32 --train_ratio 0.7 --val_ratio 0.2
