import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to modify
    output_grid = input_grid.copy()
    
    # Find all blue pixels in the grid
    blue_pixels = np.where(input_grid == blue)
    
    # Iterate over each blue pixel
    for i in range(len(blue_pixels[0])):
        row, col = blue_pixels[0][i], blue_pixels[1][i]
        # Check if there is another blue pixel in the same row
        if np.sum(input_grid[row] == blue) > 1:
            # Find the indices of the blue pixels in the same row
            blue_indices = np.where(input_grid[row] == blue)[0]
            # Sort the indices in ascending order
            blue_indices = np.sort(blue_indices)
            # Color the black pixels between the blue pixels to teal
            for j in range(blue_indices[0]+1, blue_indices[-1]):
                if input_grid[row][j] == black:
                    output_grid[row][j] = teal
        
        # Check if there is another blue pixel in the same column
        if np.sum(input_grid[:,col] == blue) > 1:
            # Find the indices of the blue pixels in the same column
            blue_indices = np.where(input_grid[:,col] == blue)[0]
            # Sort the indices in ascending order
            blue_indices = np.sort(blue_indices)
            # Color the black pixels between the blue pixels to teal
            for j in range(blue_indices[0]+1, blue_indices[-1]):
                if input_grid[j][col] == black:
                    output_grid[j][col] = teal
    
    return output_grid
    