import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Count the number of each color in the input grid and record the corresponding color
    color_counts = np.zeros((10, 2), dtype=int)
    for color in range(10):
        color_counts[color, 0] = color
        color_counts[color, 1] = np.count_nonzero(input_grid == color)
    
    # Sort the color counts from most to least
    sorted_counts = color_counts[np.argsort(color_counts[:, 1])[::-1]]
    
    # Create the output grid with the appropriate dimensions
    num_cols = np.count_nonzero(sorted_counts[:, 1])
    output_grid = np.zeros((sorted_counts[0, 1], num_cols), dtype=int)
    
    # Color each column of the output grid with the corresponding color
    col_idx = 0
    for i, (color, count) in enumerate(sorted_counts):
        if count > 0:
            output_grid[:count, col_idx] = color
            col_idx += 1
    
    return output_grid
