import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the dimensions of the input grid
    row, col = input_grid.shape

    # Create an empty output grid with the same dimensions as the input grid
    output_grid = np.zeros((row, col), dtype=int)

    # Loop through each pixel in the input grid
    for x in range(row):
        for y in range(col):
            # Check if the pixel is yellow
            if input_grid[x][y] == yellow:
                # Get the corresponding pixels for symmetry
                sym1 = input_grid[row-1-x][y]
                sym2 = input_grid[x][col-1-y]
                sym3 = input_grid[row-1-x][col-1-y]

                # Check if all corresponding pixels are the same color and not yellow
                if sym1 == sym2 == sym3 and sym1 != yellow:
                    # Set the pixel in the output grid to the corresponding color
                    output_grid[x][y] = sym1
                    output_grid[row-1-x][y] = sym1
                    output_grid[x][col-1-y] = sym1
                    output_grid[row-1-x][col-1-y] = sym1
                else:
                    # Change the yellow pixels in sym1, sym2, and sym3 to the color of the other pixels
                    if sym1 == yellow:
                        sym1 = sym2 if sym2 != yellow else sym3
                    if sym2 == yellow:
                        sym2 = sym1 if sym1 != yellow else sym3
                    if sym3 == yellow:
                        sym3 = sym1 if sym1 != yellow else sym2

                    # Check if all corresponding pixels are the same color and not yellow
                    if sym1 == sym2 == sym3 and sym1 != yellow:
                        # Set the pixel in the output grid to the corresponding color
                        output_grid[x][y] = sym1
                        output_grid[row-1-x][y] = sym1
                        output_grid[x][col-1-y] = sym1
                        output_grid[row-1-x][col-1-y] = sym1
                    else:
                        # Keep the pixel in the output grid the same as the input grid
                        output_grid[x][y] = input_grid[x][y]
                        output_grid[row-1-x][y] = input_grid[row-1-x][y]
                        output_grid[x][col-1-y] = input_grid[x][col-1-y]
                        output_grid[row-1-x][col-1-y] = input_grid[row-1-x][col-1-y]
            else:
                # Keep the pixel in the output grid the same as the input grid
                output_grid[x][y] = input_grid[x][y]

    return output_grid