import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the yellow pixel in the bottom left corner of the yellow region
    yellow_pixel = input_grid[3:6, 3:6][0, 0]
    
    # Check if the yellow pixel is in the bottom left corner
    if yellow_pixel == yellow:
        # Left-symmetric the blue pixels to the left side of the grid
        input_grid[0:3, 0:3] = np.fliplr(input_grid[0:3, 3:6])
    
    # Get the yellow pixel in the bottom right corner of the yellow region
    yellow_pixel = input_grid[3:6, 3:6][0, 2]
    
    # Check if the yellow pixel is in the bottom right corner
    if yellow_pixel == yellow:
        # Right-symmetric the blue pixels to the right side of the grid
        input_grid[0:3, 6:9] = np.fliplr(input_grid[0:3, 3:6])
    
    return input_grid
    