import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the colors of the two pixels
    upper_color = None
    lower_color = None
    for i in range(10):
        if input_grid[2][i] != 0:
            upper_color = input_grid[2][i]
        if input_grid[7][i] != 0:
            lower_color = input_grid[7][i]
        if upper_color is not None and lower_color is not None:
            break

    # Create the output grid
    output_grid = np.zeros((10, 10), dtype=int)

    # Color the 0th and 2nd line with the upper pixel's color
    output_grid[0] = upper_color
    output_grid[2] = upper_color

    # Color the 7th and 9th line with the lower pixel's color
    output_grid[7] = lower_color
    output_grid[9] = lower_color

    # Color the first and last columns with the appropriate colors
    for i in range(10):
        if i < 5:
            output_grid[i][0] = upper_color
            output_grid[i][9] = upper_color
        else:
            output_grid[i][0] = lower_color
            output_grid[i][9] = lower_color

    return output_grid