import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find rows and columns with all black pixels
    black_rows = [i for i in range(input_grid.shape[0]) if np.all(input_grid[i,:] == black)]
    black_cols = [j for j in range(input_grid.shape[1]) if np.all(input_grid[:,j] == black)]
    # Add 0 at the start and end of rows and columns
    black_rows = [0] + black_rows + [input_grid.shape[0]-1]
    black_cols = [0] + black_cols + [input_grid.shape[1]-1]
    # Divide input grid into subgrids
    subgrids = []
    for i in range(len(black_rows)-1):
        for j in range(len(black_cols)-1):
            subgrid = input_grid[black_rows[i]+1:black_rows[i+1], black_cols[j]+1:black_cols[j+1]]
            subgrids.append(subgrid)
    # Create output grid
    output_grid = np.zeros((len(black_rows)-1, len(black_cols)-1), dtype=int)
    # Fill output grid with colors
    for i in range(len(black_rows)-1):
        for j in range(len(black_cols)-1):
            subgrid = subgrids[i*(len(black_cols)-1)+j]
            colors, counts = np.unique(subgrid, return_counts=True)
            if len(colors) == 1:
                output_grid[i,j] = colors[0]
            else:
                max_count = np.max(counts)
                max_color = colors[np.argmax(counts)]
                output_grid[i,j] = max_color
    return output_grid
