import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.copy(input_grid)
    colors = [red, green, yellow, grey, pink, orange, teal, maroon]
    for color in colors:
        locations = np.where(input_grid == color)
        rows, cols = locations[0], locations[1]
        for i in range(len(rows)):
            for j in range(i+1, len(rows)):
                if rows[i] == rows[j]:
                    mid_col = (cols[i] + cols[j]) // 2
                    output_grid[rows[i], mid_col] = color
                elif cols[i] == cols[j]:
                    mid_row = (rows[i] + rows[j]) // 2
                    output_grid[mid_row, cols[i]] = color
    return output_grid
