import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the height and width of the input grid
    height, width = input_grid.shape
    
    # Create an empty output grid with the same size as the input grid
    output_grid = np.zeros((height, width), dtype=int)
    
    # Loop through each row of the input grid
    for i in range(height):
        # Flip the row vertically and assign it to the corresponding row in the output grid
        output_grid[i] = input_grid[height-i-1]
    
    return output_grid
