import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to modify
    output_grid = input_grid.copy()
    
    # Find all black inner pixels whose 3 of 4 neighbors is not black
    for i in range(1, input_grid.shape[0]-1):
        for j in range(1, input_grid.shape[1]-1):
            if input_grid[i][j] == black:
                neighbors = [input_grid[i-1][j], input_grid[i+1][j], input_grid[i][j-1], input_grid[i][j+1]]
                if neighbors.count(black) == 1:
                    # Find the bottom-most pixel in the same column
                    k = i
                    while k < input_grid.shape[0]-1 and input_grid[k+1][j] == black:
                        k += 1
                    # Color the bottom-most pixel in yellow
                    output_grid[k][j] = yellow
    
    return output_grid