import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the color of the middle row
    middle_row_color = input_grid[len(input_grid)//2][0]
    
    # Change the pattern to the color of the middle row
    for i in range(len(input_grid)):
        for j in range(len(input_grid[i])):
            if input_grid[i][j] != black:
                input_grid[i][j] = middle_row_color
    
    # Draw a mirror pattern on the middle row axis
    for i in range(len(input_grid)//2):
        input_grid[len(input_grid)-i-1] = input_grid[i]
    
    # Draw a mirror pattern on the middle column axis
    for i in range(len(input_grid)):
        for j in range(len(input_grid[i])//2):
            input_grid[i][len(input_grid[i])-j-1] = input_grid[i][j]
    
    # Make symmetrical pattern with center point
    for i in range(len(input_grid)//2):
        for j in range(len(input_grid[i])//2):
            input_grid[len(input_grid)-i-1][len(input_grid[i])-j-1] = input_grid[i][j]
    
    # Delete the middle row and middle column
    input_grid = np.delete(input_grid, len(input_grid)//2, axis=0)
    input_grid = np.delete(input_grid, len(input_grid[0])//2, axis=1)
    
    return input_grid