import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find all grey positions in the input
    grey_positions = np.where(input_grid == grey)

    # Change positions up, down, left, and right to blue
    for i, j in zip(grey_positions[0], grey_positions[1]):
        if i > 0:
            input_grid[i-1, j] = blue
        if i < input_grid.shape[0]-1:
            input_grid[i+1, j] = blue
        if j > 0:
            input_grid[i, j-1] = blue
        if j < input_grid.shape[1]-1:
            input_grid[i, j+1] = blue

        # Change positions of input coordinates to grey
        if i > 0 and j > 0:
            input_grid[i-1, j-1] = grey
        if i > 0 and j < input_grid.shape[1]-1:
            input_grid[i-1, j+1] = grey
        if i < input_grid.shape[0]-1 and j > 0:
            input_grid[i+1, j-1] = grey
        if i < input_grid.shape[0]-1 and j < input_grid.shape[1]-1:
            input_grid[i+1, j+1] = grey


    # Change positions of input coordinates to black
    input_grid[grey_positions] = black

    return input_grid