import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the indices of all yellow blocks
    yellow_indices = np.argwhere(input_grid == yellow)

    # Find the minimum and maximum indices of the yellow blocks
    min_indices = np.min(yellow_indices, axis=0)
    max_indices = np.max(yellow_indices, axis=0)

    # Calculate the size of the smallest rectangle that can contain all yellow blocks
    width = max_indices[1] - min_indices[1] + 1
    height = max_indices[0] - min_indices[0] + 1

    # Create the output grid with four times the smallest rectangle size
    output_grid = np.zeros((height*2, width*2), dtype=int)

    # Copy the yellow blocks to the output grid
    for index in yellow_indices:
        # Calculate the indices of the four blocks in the square
        row_start = (index[0]-min_indices[0])*2
        row_end = row_start + 2
        col_start = (index[1]-min_indices[1])*2
        col_end = col_start + 2

        # Set the four blocks in the square to yellow
        output_grid[row_start:row_end, col_start:col_end] = yellow

    return output_grid


