import numpy as np

def find_zero_rectangles(grid):
    zero_rectangles = []
    for i in range(grid.shape[0]-2):
        for j in range(grid.shape[1]-2):
            if np.all(grid[i:i+3, j:j+3] == 0):
                zero_rectangles.append((i,j))
    return zero_rectangles

def replace_zero_rectangles(grid, zero_rectangles):
    for i,j in zero_rectangles:
        grid[i:i+3, j:j+3] = 1
    return grid

def main(input_grid):
    zero_rectangles = find_zero_rectangles(input_grid)
    output_grid = replace_zero_rectangles(input_grid.copy(), zero_rectangles)
    return output_grid