import numpy as np

(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Step 1: Find teal pixel and paint row and column teal
    x1, y1 = None, None
    for i in range(input_grid.shape[0]):
        if x1 is not None and y1 is not None:
            break
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == teal:
                x1, y1 = i, j
                input_grid[i,:] = teal
                input_grid[:,j] = teal
                break

    # Step 2: Find orange pixel and paint row and column orange
    x2, y2 = None, None
    for i in range(input_grid.shape[0]):
        if x2 is not None and y2 is not None:
            break
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == orange:
                x2, y2 = i, j
                input_grid[i,:] = orange
                input_grid[:,j] = orange
                break

    # Step 3: Paint pixels at (x1,y2) and (x2,y1) red
    input_grid[x1][y2] = red
    input_grid[x2][y1] = red

    return input_grid