# Coin MIED
This folder contains code for implementing Coin MIED.

## Installation
To install the package, use `pip install -e .` or `conda develop .`

## Requirements
The full list of dependencies are listed in `requirements.txt`.

## Experiments
The results for Coin MIED in the paper can be reproduced as follows.

#### Uniform Target

- In `results/uniform`, run `uniform_script.py` to generate the results, 
and then `uniform_plot_script` to generate the resulting plots.


- The complete set of results are already stored in `results/uniform`, so 
`uniform_plot_script` can be used to generate the plots without re-running
the experiments.

#### Fairness Bayesian Neural Network

- In `results/fairness_bnn`, `fairness_bnn_script` contains an example
script used to generate results for Coin MIED and MIED, for a particular
value of the constraint parameter t.
- The complete set of results for Coin MIED and MIED can be reproduced by
running `fairness_bnn_script` for all values of t in the paper. 


- The complete set of results for Coin MIED, MIED, and the other methods 
considered in the paper are stored in the relevant directories in `results/fairness_bnn`.
- To process all of these results, and generate the plots in the paper, 
run `process_results.py`.



## Notes
The code in this repository is built on top of the official 
implementation of MIED which accompanies the paper

```
@article{li2023_mied,
  title={Sampling with Mollified Interaction Energy Descent}, 
  author={Lingxiao Li and Qiang Liu and Anna Korba and Mikhail Yurochkin and Justin Solomon},
  journal={International Conference on Learning Representations},
  year={2023}
}
```

The code for that paper is publicly available on GitHub at 
https://github.com/lingxiaoli94/MIED








