import time
from itertools import *
import numpy as np
import csv
import pandas as pd
import random
from sys import argv
import math
import random
from gurobipy import Model, GRB
from gurobipy import quicksum
#import cplex
#from docplex.mp.model import Model


def tmps(S,A,kp,ka):
	numrev, numpap = S.shape
	problem = Model()
	problem.setParam('OutputFlag', False)
	X = problem.addVars(numrev,numpap, vtype=GRB.BINARY, name='assignment')
	problem.addConstrs((X[i,j] <= 1-A[i,j] for i in range(numrev) for j in range(numrev)))

	problem.addConstrs(( X.sum('*',j) == kp  for j in range(numpap)) )
	problem.addConstrs( (X.sum(i,'*') <= ka  for i in range(numrev)) ) #if r deviates,  it can be assigned at most ka submissions

	problem.update()
	problem.setObjective(quicksum( [X[i,j]*S[i,j] for i in range(numrev) for j in range(numpap) ]), GRB.MAXIMIZE)
	problem.update()
	problem.optimize()
	F=np.zeros((numrev, numpap ))
	for j in range(numpap):
		for i in range(numrev):
			F[i,j]=X[i,j].x
	return F


# def tmps(S,A,kp,ka):
# 	numrev, numpap = S.shape
# 	#m=cplex.Cplex()
# 	m=Model("OBJ1")
# 	X=m.binary_var_dict((i,j) for i in range(numrev) for j in range(numpap))
#
# 	for i in range(numrev):
# 		for j in range(numpap):
# 			c1= m.add_constraint(X[i,j]<=1-A[i,j])
#
# 	for i in range(numrev):
# 		c2=m.add_constraint(sum(X[i,j] for j in range(numpap))<=ka)
# 	for j in range(numpap):
# 		c3=m.add_constraint(sum(X[i,j] for i in range(numrev))==kp)
#
# 	obj=sum(X[i,j]*S[i,j] for j in range(numpap) for i in range(numrev))
# 	m.set_objective("max",obj)
# 	m.solve()
# 	#sol=m.solution()
# 	#print(m.solution.get_status())
# 	F=np.zeros((numrev, numpap ))
# 	for i in range(numrev):
# 		for j in range(numpap):
# 			F[i,j]=m.solution.get_value(X[i,j])
#
#
# 	return F

	#
	# nrev, npap = S.shape
	# prob = LpProblem("Assignment-TPMS",LpMaximize)
	#
	# X = pulp.LpVariable.dicts("assign",
	# 							((r,p) for r in range(nrev) for p in range(npap)),
	# 							lowBound=0,
	# 							upBound=1,
	# 							cat='Binary')
	#
	#
	#
	# prob +=  pulp.lpSum([X[r,p]*S[r,p] for r in range(nrev) for p in range(npap)])
	#
	#
	# for r in  range(nrev):
	# 	for p in range(npap):
	# 		prob += X[r,p] <=1- A[r,p]#r cannot review p if r is the author of p
	#
	# for p in  range(npap):
	# 	prob += pulp.lpSum([X[r,p] for r in range(nrev)]) == kp
	#
	# for r in  range(nrev):
	# 	prob += pulp.lpSum([X[r,p] for p in range(npap)]) <= ka
	#
	# prob.solve()
	# F=np.zeros((nrev,npap))
	# for r in range(nrev):
	# 	for p in range(npap):
	# 		F[r,p]=X[r,p].value()
	# return F
