import numpy as np

from MarkovChains.MarkovChain import MarkovChain


def generate_worstcase1_mc(num_states=2, num_dimensions=100, seed=777, cov_eigengap_threshold=60):
    # Check that the number of states is 2
    assert (num_states == 2)

    np.random.seed(seed)
    epsilon = 5e-3
    transition_matrix = np.array([[1-epsilon, epsilon],
                                  [epsilon, 1-epsilon]])

    means = np.zeros((num_states, num_dimensions))

    covariance_matrices = []
    v = np.exp(-1*np.arange(num_dimensions))
    v1 = np.zeros(num_dimensions)
    v2 = np.zeros(num_dimensions)
    v1[num_dimensions // 2:] = v[num_dimensions // 2:]
    v2[:num_dimensions // 2] = v[:num_dimensions // 2]
    # v1[:num_dimensions // 2] = np.random.uniform(0, 1, len(v1[:num_dimensions // 2]))
    # v1[num_dimensions // 2:] = 1e-2*np.random.uniform(0, 1, len(v1[num_dimensions // 2:]))
    # v2[:num_dimensions // 2] = 1e-2*np.random.uniform(0, 1, len(v2[:num_dimensions // 2]))
    # v2[num_dimensions // 2:] = np.random.uniform(0, 1, len(v2[num_dimensions // 2:]))
    # v1[num_dimensions // 2] = 5
    cov1 = np.diag(v1)
    cov2 = np.diag(v2)
    cov1 = (cov1 + np.transpose(cov1)) / 2
    cov2 = (cov2 + np.transpose(cov2)) / 2
    cov1 = cov1*100
    cov2 = cov2*100
    covariance_matrices.append(cov1)
    covariance_matrices.append(cov2)
    covariance_matrices = np.array(covariance_matrices)

    initial_distribution = abs(np.random.randn(num_states))
    initial_distribution /= np.sum(initial_distribution)

    markov_chain = MarkovChain(transition_matrix=transition_matrix,
                               means=means,
                               covariance_matrices=covariance_matrices,
                               initial_distribution=initial_distribution,
                               seed=seed)

    markov_chain.print()
    return markov_chain
