function Exp_Avg(file)

    for j = 1:6
        load(file(j).name,'DI_MAT_SC','FIT_MAT_SC','cFIT_MAT_SC','FITshared_MAT_SC');
        DI_MATT_EXP_SC(j,:,:,:,:,:,:,:) = DI_MAT_SC;
        FIT_MATT_EXP_SC(j,:,:,:,:,:,:,:) = FIT_MAT_SC;
        cFIT_MATT_EXP_SC(j,:,:,:,:,:,:,:) = cFIT_MAT_SC;
        FITshared_MATT_EXP_SC(j,:,:,:,:,:,:,:) = FITshared_MAT_SC;
    end
    
    clear *_MAT_*


    %%%%%% MEAN SEM %%%%%
    N = 6;
    
    DI_EXP_MEAN_SC = squeeze(mean(DI_MATT_EXP_SC,1));
    DI_EXP_SEM_SC = squeeze(std(DI_MATT_EXP_SC,0,1))./sqrt(N);
    FIT_EXP_MEAN_SC = squeeze(mean(FIT_MATT_EXP_SC,1));
    FIT_EXP_SEM_SC = squeeze(std(FIT_MATT_EXP_SC,0,1))./sqrt(N);
    cFIT_EXP_MEAN_SC = squeeze(mean(cFIT_MATT_EXP_SC,1));
    cFIT_EXP_SEM_SC = squeeze(std(cFIT_MATT_EXP_SC,0,1))./sqrt(N);
    FITshared_EXP_MEAN_SC = squeeze(mean(FITshared_MATT_EXP_SC,1));
    FITshared_EXP_SEM_SC = squeeze(std(FITshared_MATT_EXP_SC,0,1))./sqrt(N);
    
    save('DI_FIT_cFIT_FITshared_EXP_MEAN_SEM.mat', 'DI_EXP_MEAN_SC', 'DI_EXP_SEM_SC',... 
                                    'FIT_EXP_MEAN_SC', 'FIT_EXP_SEM_SC',... 
                                    'cFIT_EXP_MEAN_SC', 'cFIT_EXP_SEM_SC', ...
                                    'FITshared_EXP_MEAN_SC', 'FITshared_EXP_SEM_SC', '-v7.3');

    
    
    if isunix
        save('DI_FIT_cFIT_FITshared_MATT.mat','-v7.3')
    elseif ispc
        save(['DI_FIT_cFIT_FITshared_MATT.mat','-v7.3']);
    else
        disp('Platform not supported')
    end
    
end



    