function [FITS_td_map,DI_td_map,FITS_td_mapSh] = plot_time_delay_maps_visNet_v4(timeDelayMaps,timeDelayMapsSh,computedROIs,sort_idxs,plot_times,ceLab,plot_pair,params,paths)
%  adapted to bootstrap method for nullhyp

delays = [params.minSelDelay*16.7:16.7:params.maxSelDelay*16.7];


[FITS_td_map,FITS_td_mapSh] = time_delay_groupsPairs_visNet_v4(timeDelayMaps, timeDelayMapsSh, params.info_type{2}, 'band_40_75', computedROIs, sort_idxs, params);
[FITC_td_map,FITC_td_mapSh] = time_delay_groupsPairs_visNet_v4(timeDelayMaps, timeDelayMapsSh, params.info_type{3}, 'band_40_75', computedROIs, sort_idxs, params);
[DI_td_map,DI_td_mapSh] = time_delay_groupsPairs_visNet_v4(timeDelayMaps, timeDelayMapsSh, params.info_type{1}, 'band_40_75', computedROIs, sort_idxs, params);
    
maxY{1} = max(max([FITS_td_map.all.(plot_pair).forward'; FITS_td_map.all.(plot_pair).feedback']));
maxY{2} = max(max([FITC_td_map.all.(plot_pair).forward'; FITC_td_map.all.(plot_pair).feedback']));
maxY{3} = max(max([DI_td_map.all.(plot_pair).forward'; DI_td_map.all.(plot_pair).feedback']));

fig=figure();
% FIT_S
subplot(3,2,1)
imagesc(plot_times,delays,FITS_td_map.all.(plot_pair).forward')
title(['FIT_S, feedforward'])
colorbar();
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')
caxis([0,maxY{1}]);
subplot(3,2,2)
imagesc(plot_times,delays,FITS_td_map.all.(plot_pair).feedback')
title(['FIT_S, feedback'])
colorbar();
caxis([0,maxY{1}]);
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')

% FIT_C
subplot(3,2,3)
imagesc(plot_times,delays,FITC_td_map.all.(plot_pair).forward')
title(['FIT_C, feedforward'])
colorbar();
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')
caxis([0,maxY{1}]);
subplot(3,2,4)
imagesc(plot_times,delays,FITC_td_map.all.(plot_pair).feedback')
title(['FIT_C, feedback'])
colorbar();
caxis([0,maxY{1}]);
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')

% DI
subplot(3,2,5)
imagesc(plot_times,delays,DI_td_map.all.(plot_pair).forward')
title('DI, feedforward')
colorbar();
caxis([0,maxY{3}]);
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')
subplot(3,2,6)
imagesc(plot_times,delays,DI_td_map.all.(plot_pair).feedback')
title('DI, feedback')
colorbar();
caxis([0,maxY{3}]);
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')

sgtitle(['Time-delay maps, average across all regions pairs in gamma'])

if params.save_figures
    fname = [paths.figuresPath,'\visNet_TD_maps_',date,'.png'];
    saveas(fig,fname)
    fname = [paths.figuresPath,'\visNet_TD_maps_',date,'.fig'];
    saveas(fig,fname)
    fname = [paths.figuresPath,'\visNet_TD_maps_',date,'.svg'];
    fig.Renderer = 'painters';
    saveas(fig,fname)
end

% Compute and plot FIT significance masks

fig=figure();
myColorMap = parula(256);
myColorMap(1,:) = 1;
colormap(myColorMap);
subplot(2,1,1)
% Feedforward
infQuant = FITS_td_map.all.(plot_pair).forward;
infQuantSh = FITS_td_mapSh.all.(plot_pair).forward;
msk = clusterStat_v2(infQuant,infQuantSh,params.clusterParams(1),params.clusterParams(2));

imagesc(plot_times,delays,(msk.*infQuant)')
title(['FIT_S, feedforward'])
colorbar();
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')
caxis([0,maxY{1}]);
subplot(2,1,2)
% Feedback
infQuant = FITS_td_map.all.(plot_pair).feedback;
infQuantSh = FITS_td_mapSh.all.(plot_pair).feedback;
msk = clusterStat_v2(infQuant,infQuantSh,params.clusterParams(1),params.clusterParams(2));

imagesc(plot_times,delays,(msk.*infQuant)')
title(['FIT_S, feedback'])
colorbar();
caxis([0,maxY{1}]);
xlabel('time of the receiver [ms]')
ylabel('delay [ms]')

sigThresh = num2str(params.clusterParams(1));
sigThresh = replace(sigThresh,'.','');

if params.save_figures
    fname = [paths.figuresPath,'\visNet_TD_sigMaps_p',sigThresh,'_',num2str(params.nBoot),'boot_',date,'.png'];
    saveas(fig,fname)
    fname = [paths.figuresPath,'\visNet_TD_sigMaps_p',sigThresh,'_',num2str(params.nBoot),'boot_',date,'.fig'];
    saveas(fig,fname)
    fname = [paths.figuresPath,'\visNet_TD_sigMaps_p',sigThresh,'_',num2str(params.nBoot),'boot_',date,'.svg'];
    fig.Renderer = 'painters';
    saveas(fig,fname)
end


end