function plot_FIT_corr_err_comparison_v1(sessDirectTransf,selFreq,selDir,statistical_test,params,glm_pred,sel_time_window)

for infoIdx = 1:numel(params.info_type)
    infoLab = params.info_type{infoIdx};
    
    % All ROIs
    figure()

    for freqIdx = 1:numel(selFreq)
        freqLab = selFreq{freqIdx};
        dirLab = selDir{freqIdx};

        subplot(1,2,freqIdx)
        hold on
        if strcmp(params.fwd_fbk_pooling,'mean')
            meas1 = nanmean(sessDirectTransf.corr.(infoLab).(freqLab).allROIs.(dirLab),2);
            error1 = std(meas1)/sqrt(params.nSubj);
            meas2 = nanmean(sessDirectTransf.err.(infoLab).(freqLab).allROIs.(dirLab),2);
            error2 = std(meas2)/sqrt(params.nSubj);

            bar(1,mean(meas1))
            bar(2,mean(meas2))
            errorbar(1,mean(meas1),error1,'k')
            errorbar(2,mean(meas2),error2,'k')

            measures=[meas1; meas2];
        elseif strcmp(params.fwd_fbk_pooling,'sum')
            meas1 = sum(sessDirectTransf.corr.(infoLab).(freqLab).allROIs.(dirLab),2,'omitnan');
            error1 = std(meas1)/sqrt(params.nSubj);
            meas2 = sum(sessDirectTransf.err.(infoLab).(freqLab).allROIs.(dirLab),2,'omitnan');
            error2 = std(meas2)/sqrt(params.nSubj);

            bar(1,mean(meas1))
            bar(2,mean(meas2))
            errorbar(1,mean(meas1),error1,'k')
            errorbar(2,mean(meas2),error2,'k')

            measures=[meas1; meas2];
        end
        maxY = max([mean(meas1)+error1,mean(meas2)+error2]);

        tbl = table(measures,glm_pred.subjects_idxs',glm_pred.conditions','VariableNames',{'measures','Subj','Cond'});
        model = fitglme(tbl,'measures~Cond + (1|Subj)', 'Distribution', 'normal');
        pval_glme =  model.Coefficients.pValue(2);
        [~,pval_ttest] = ttest(meas1,meas2);
        if strcmp(statistical_test,'ttest_sessions')
            pvalues_plot(pval_ttest,1.5,maxY,maxY/10,maxY/100,14,1,'k',0)
        elseif strcmp(statistical_test,'glme')
            pvalues_plot(pval_glme,1.5,maxY,maxY/10,maxY/100,14,1,'k',0)
        end
        set(gca, 'XTick', [1 2], 'XTickLabel', {'correct','error'}, 'fontsize', 12)
        title([freqLab,' ',dirLab])
    end
    sgtitle(['Correct vs error comparison ',infoLab,', all ROIs; T=[',num2str(sel_time_window(1)),',',num2str(sel_time_window(2)),']s'])

    % Visual ROIs
    figure()

    for freqIdx = 1:numel(selFreq)
        freqLab = selFreq{freqIdx};
        dirLab = selDir{freqIdx};

        subplot(1,2,freqIdx)
        hold on
        if strcmp(params.fwd_fbk_pooling,'mean')
            meas1 = nanmean(sessDirectTransf.corr.(infoLab).(freqLab).visROIs.(dirLab),2);
            error1 = std(meas1)/sqrt(params.nSubj);
            meas2 = nanmean(sessDirectTransf.err.(infoLab).(freqLab).visROIs.(dirLab),2);
            error2 = std(meas2)/sqrt(params.nSubj);

            bar(1,mean(meas1))
            bar(2,mean(meas2))
            errorbar(1,mean(meas1),error1,'k')
            errorbar(2,mean(meas2),error2,'k')

            measures=[meas1; meas2];
        elseif strcmp(params.fwd_fbk_pooling,'sum')
            meas1 = sum(sessDirectTransf.corr.(infoLab).(freqLab).visROIs.(dirLab),2,'omitnan');
            error1 = std(meas1)/sqrt(params.nSubj);
            meas2 = sum(sessDirectTransf.err.(infoLab).(freqLab).visROIs.(dirLab),2,'omitnan');
            error2 = std(meas2)/sqrt(params.nSubj);

            bar(1,mean(meas1))
            bar(2,mean(meas2))
            errorbar(1,mean(meas1),error1,'k')
            errorbar(2,mean(meas2),error2,'k')

            measures=[meas1; meas2];
        end
        maxY = max([mean(meas1)+error1,mean(meas2)+error2]);

        tbl = table(measures,glm_pred.subjects_idxs',glm_pred.conditions','VariableNames',{'measures','Subj','Cond'});
        model = fitglme(tbl,'measures~Cond + (1|Subj)', 'Distribution', 'normal');
        pval_glme =  model.Coefficients.pValue(2);
        [~,pval_ttest] = ttest(meas1,meas2);
        if strcmp(statistical_test,'ttest_sessions')
            pvalues_plot(pval_ttest,1.5,maxY,maxY/10,maxY/100,14,1,'k',0)
        elseif strcmp(statistical_test,'glme')
            pvalues_plot(pval_glme,1.5,maxY,maxY/10,maxY/100,14,1,'k',0)
        end
        set(gca, 'XTick', [1 2], 'XTickLabel', {'correct','error'}, 'fontsize', 12)
        title([freqLab,' ',dirLab])
    end
    sgtitle(['Correct vs error comparison ',infoLab,', visual ROIs; T=[',num2str(sel_time_window(1)),',',num2str(sel_time_window(2)),']s'])

end

end