function [ L, num, values ] = createClusters( infQuant, clusterPercentilThreshold )
%% createClusters creates clusters based on the criteria and computes the
% values of the statistic for them
%   
% infQuant should be a rectangular matrix of values of the information
% quantity

percentil = clusterPercentilThreshold;
% take only non-zero values beacuse sometimes we don't compute the whole
% matrix and our quantities shouldn't be exactly zero even if they are very
% low
nnzIQ = nonzeros(infQuant);
sortedValues = sort(nnzIQ);

% just a corner case when there aren't enough of values
if round(percentil * length(sortedValues)) < 1
    L = zeros(size(infQuant));
    num = 0;
    values = [];
else
    % create a bit mask of all those that are above the threshold
    minValid = sortedValues(round(percentil * length(sortedValues)));
    valid = infQuant >= minValid;
    
    % create clusters
    [L, num] = bwlabel(valid,8); % modified, originally 8

    % sum the t-values for them
    values = zeros(num, 1);
    for i = 1:num
        values(i) = sum(sum(infQuant(L == i)));
    end
end

