#!/bin/bash

echo starting job...
source ~/.bashrc
conda activate ww_train
export PYTHONUNBUFFERED=1
export OMP_NUM_THREADS=1


root=$(pwd)
data_root=$(pwd)/data
ckpt_root=$(pwd)/checkpoints


cd ${root}/src

for SLURM_ARRAY_TASK_ID in {108..167..1}
    do 
        cfg=$(sed -n "$SLURM_ARRAY_TASK_ID"p ${root}/src/scripts/txt_file/baseline_more_arch.txt)

        netType=$(echo $cfg | cut -f 1 -d ' ')
        width=$(echo $cfg | cut -f 2 -d ' ')
        depth=$(echo $cfg | cut -f 3 -d ' ')
        dataset=$(echo $cfg | cut -f 4 -d ' ')
        num_epochs=$(echo $cfg | cut -f 5 -d ' ')
        lr_sche=$(echo $cfg | cut -f 6 -d ' ')
        seed=$(echo $cfg | cut -f 7 -d ' ')
        lr=$(echo $cfg | cut -f 8 -d ' ')
        weight_decay=$(echo $cfg | cut -f 9 -d ' ')
        warmup_epochs=$(echo $cfg | cut -f 10 -d ' ')
        fix_fingers=$(echo $cfg | cut -f 11 -d ' ')

        ww_interval=1
        base_path=${ckpt_root}/${netType}/baseline_interval1


        wandb_tag=${netType}_${depth}_${width}_${dataset}_${lr}_${lr_sche}_${num_epochs}_wd${weight_decay}_seed${seed}_warm${warmup_epochs}_fixf${fix_fingers}_interval${ww_interval}
        mkdir -p ${base_path}/${wandb_tag}

        CUDA_VISIBLE_DEVICES=0 python main_baseline.py \
            --lr ${lr} \
            --net-type ${netType} \
            --depth ${depth} \
            --num-epochs ${num_epochs} \
            --widen-factor ${width} \
            --warmup-epochs ${warmup_epochs} \
            --seed ${seed} \
            --wandb-on False \
            --print-tofile False \
            --dataset ${dataset} \
            --lr-sche ${lr_sche} \
            --datadir ${data_root} \
            --ww-interval ${ww_interval} \
            --weight-decay ${weight_decay} \
            --wandb-tag ${wandb_tag} \
            --fix-fingers ${fix_fingers} \
            --ckpt-path ${base_path}/${wandb_tag}

    done