# Codes for "A Recurrent Neural Circuit Mechanism of Temporal-scaling Equivariant Representation"
## Requirements
The simulations were coded in Python. It requires that `python>=3.7.0` is installed on your computer. Several python packages were used in our codes, including `numpy` for numerical computation, `scipy` for special functions, data smoothing and dataloading, `sklearn` for PCA and linear regression, `torch` for MLP training, and `matplotlib` for figure plotting. The versions of the packages we used are provided in `requirements.txt`. Please make sure that these packages are already prepared on your computer before running our codes.

## Codes
`CANN_1D.py` implements a 1 dimensional continuous attractor neural network model.  
`Plot.py` plots the figures of Figure 3 in the main text except Fig3C(bottom) and Fig3E. Fig3C(bottom) requires rotating the 3D figure manually.  
`Weber.py` counts the time durations and its standard deviations under different input strength, and fits a linear relationship betwen them (Fig3E in the main text).
`NeuralSeq.py` generates neural sequences in different temporal scales shown in Fig2G and Fig3A.  
`HandWrittenDigit` includes codes and data of training and testing the MLP we used for generating hand-written sequences. We also includes the trained models for each digit.
