# Rethinking Rendering in Generalizable Neural Surface Reconstruction: A Learning-based Solution

## Outline
Generalizable neural surface reconstruction techniques have attracted great attention in recent years. However, they encounter limitations of low confidence depth distribution and inaccurate surface reasoning due to the oversimplified volume rendering process employed. In this paper, we present Reconstruction TRansformer (ReTR), a novel framework that leverages the transformer architecture to redesign the rendering process, enabling complex photon-particle interaction modeling. It introduces a learnable \textit{meta-ray token} and utilizes the cross-attention mechanism to simulate the interaction of photons with sampled points and render the observed color. Meanwhile, by operating within a high-dimensional feature space rather than the color space, ReTR mitigates sensitivity to projected colors in source views. Such improvements result in accurate surface assessment with high confidence. We demonstrate the effectiveness of our approach on various datasets, showcasing how our method outperforms the current state-of-the-art approaches in terms of reconstruction quality and generalization ability. 

### Prerequsites

- Main framework
    Python 3.9
    CUDA 11.1
    cuDNN 8.0.5
    Pytorch 1.10.1

- Package
    torchvision
    numpy
    SharedArray
    opencv-python
    piq
    einops
    wandb
    pytorch_lightning
    GPUtil
    termcolor
    ipdb
    PyMCubes
    trimesh
    plyfile
    pillow
    scikit-image=0.16.2
    numba
    pycuda
    open3d
    scikit-learn

### Code Structure

- code:
    Contains all dataloader and model files

- evaluation
    Contains evaluation code for reproduce our Main table results

- main.py
    The control of evaluation code

- script
    Files that should be run in the following order: eval_dtu.sh, tsdf_fuison.sh, clean_mesh.sh, eval_dtu_result.sh

### Parameters

Please see eval_dtu.sh for more example. The main.py has all the parameters with description, we will only list few here for reference as you should run script files instead of calling main.py directly

- `root_dir`: directory of dataset
- `load_ckpt`: loading checkpoints
- `max_epochs`: max number of epochs to run
- `test_dir`: directory of testing dataset
- `out_dir`: folder that will save the inference result
- `occ_trans`: use occlusion aware transformer, default set to true

More details please see description in main.py

### Tranining loop

Will be released soon!

### Demonstraions

Usage:
$bash script/eval_dtu.sh

