load('BankMarketing_deterministic_weakly_convex_workspace_nostationarity_with_cputime.mat');
load('SSG_stationarity_measure.mat');
load('IPP_SSG_stationarity_measure.mat');
load('IPP_ConEx_stationarity_measure.mat');

% Reference: https://www.mathworks.com/help/matlab/ref/colororder.html
newcolors = [0.83 0.14 0.14
             0.47 0.25 0.80
             0.00 0.46 0.74];

colororder(newcolors)

fig_obj_vs_iteration = plot(0:numitersub_ub:step_count_ssg, SSG_obj_candidate(1:numitersub_ub:(step_count_ssg+1)), 'LineWidth', 1.5);
% Reference: https://www.mathworks.com/help/matlab/ref/gca.html
ax = gca; % current axes
ax.XAxis.Exponent = 5;
hold on
plot(0:numitersub_ub:(step_count_ippssg), IPP_SSG_obj_candidate, 'LineWidth', 1.5);
plot(0:numitersub_ub:(step_count_ippconex), IPP_ConEx_obj_candidate, 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Iteration t');
xlim([0 step_count_ssg]);
% ylabel('\fontsize{12}Objective');
legend({'\fontsize{16}SSG', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','northeast');
% title('\fontsize{20}Objective');
saveas(fig_obj_vs_iteration, 'BankMarketing_deterministic_weakly_convex_objective_result_vs_iteration.eps','epsc');

fig_obj_vs_cputime = plot(SSG_time_set(1:numitersub_ub:(step_count_ssg+1)), SSG_obj_candidate(1:numitersub_ub:(step_count_ssg+1)), 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 3;
hold on
plot(IPP_SSG_time_set(1:numitersub_ub:(step_count_ippssg+1)), IPP_SSG_obj_candidate, 'LineWidth', 1.5);
plot(IPP_ConEx_time_set(1:numitersub_ub:(step_count_ippconex+1)), IPP_ConEx_obj_candidate, 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Second (s)');
xlim([0 min([SSG_time_set(step_count_ssg+1), IPP_SSG_time_set(step_count_ippssg+1), IPP_ConEx_time_set(step_count_ippconex+1)])]);
% ylabel('\fontsize{12}Objective');
legend({'\fontsize{16}SSG', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','northeast');
% title('\fontsize{20}Objective');
saveas(fig_obj_vs_cputime, 'BankMarketing_deterministic_weakly_convex_objective_result_vs_cputime.eps','epsc');

dash_line_length = step_count_ssg;
fig_cons_vs_iteration = plot(0:999:step_count_ssg, SSG_cons_candidate(1:999:length(SSG_cons_candidate)), 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 5;
hold on
plot(0:numitersub_ub:(step_count_ippssg), IPP_SSG_cons_candidate, 'LineWidth', 1.5);
plot(0:numitersub_ub:(step_count_ippconex), IPP_ConEx_cons_candidate, 'LineWidth', 1.5);
plot(0:dash_line_length, zeros(1, dash_line_length+1), 'black--', 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Iteration t');
xlim([0 step_count_ssg]);
ylim([-1e-3 5e-4]);
% ylabel('\fontsize{12}Feasibility');
legend({'\fontsize{16}SSG', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','southeast');
% title('\fontsize{20}Feasibility');
saveas(fig_cons_vs_iteration, 'BankMarketing_deterministic_weakly_convex_feasibility_result_vs_iteration.eps','epsc');

dash_line_length = ceil(min([SSG_time_set(step_count_ssg+1), IPP_SSG_time_set(step_count_ippssg+1), IPP_ConEx_time_set(step_count_ippconex+1)]));
fig_cons_vs_cputime = plot(SSG_time_set(1:666:(step_count_ssg+1)), SSG_cons_candidate(1:666:(step_count_ssg+1)), 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 3;
hold on
plot(IPP_SSG_time_set(1:numitersub_ub:(step_count_ippssg+1)), IPP_SSG_cons_candidate, 'LineWidth', 1.5);
plot(IPP_ConEx_time_set(1:numitersub_ub:(step_count_ippconex+1)), IPP_ConEx_cons_candidate, 'LineWidth', 1.5);
plot(0:dash_line_length, zeros(1, dash_line_length+1), 'black--', 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Second (s)');
xlim([0 min([SSG_time_set(step_count_ssg+1), IPP_SSG_time_set(step_count_ippssg+1), IPP_ConEx_time_set(step_count_ippconex+1)])]);
ylim([-1e-3 5e-4]);
% ylabel('\fontsize{12}Objective');
legend({'\fontsize{16}SSG', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','southeast');
% title('\fontsize{20}Feasibility');
saveas(fig_cons_vs_cputime, 'BankMarketing_deterministic_weakly_convex_feasibility_result_vs_cputime.eps','epsc');

stationarity_frequency = numitersub_ub;
fig_sta_vs_iteration = plot(0:stationarity_frequency:((length(SSG_stationarity_measure)-1)*stationarity_frequency), ...
                            SSG_stationarity_measure, 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 5;
hold on
plot(0:stationarity_frequency:((length(IPP_SSG_stationarity_measure)-1)*stationarity_frequency), ...
     IPP_SSG_stationarity_measure, 'LineWidth', 1.5);
plot(0:stationarity_frequency:((length(IPP_ConEx_stationarity_measure)-1)*stationarity_frequency), ...
     IPP_ConEx_stationarity_measure, 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Iteration t');
xlim([0 step_count_ssg]);
% ylabel('\fontsize{12}Stationarity');
legend({'\fontsize{16}SSG', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','northeast');
% title('\fontsize{20}Stationarity');
saveas(fig_sta_vs_iteration, 'BankMarketing_deterministic_weakly_convex_stationarity_result_vs_iteration.eps','epsc');

fig_sta_vs_cputime = plot(SSG_time_set(1:stationarity_frequency:((length(SSG_stationarity_measure)-1)*stationarity_frequency+1)), ...
                          SSG_stationarity_measure, 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 3;
hold on
plot(IPP_SSG_time_set(1:stationarity_frequency:((length(IPP_SSG_stationarity_measure)-1)*stationarity_frequency+1)), ...
     IPP_SSG_stationarity_measure, 'LineWidth', 1.5);
plot(IPP_ConEx_time_set(1:stationarity_frequency:((length(IPP_ConEx_stationarity_measure)-1)*stationarity_frequency+1)), ...
     IPP_ConEx_stationarity_measure, 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Second (s)');
xlim([0 min([SSG_time_set(step_count_ssg+1), IPP_SSG_time_set(step_count_ippssg+1), IPP_ConEx_time_set(step_count_ippconex+1)])]);
% ylabel('\fontsize{12}Stationarity');
legend({'\fontsize{16}SSG', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','northeast');
% title('\fontsize{20}Stationarity');
saveas(fig_sta_vs_cputime, 'BankMarketing_deterministic_weakly_convex_stationarity_result_vs_cputime.eps','epsc');