function subgrad = objective_subgradient(Ac, idmalec, idfemalec, nummalec, numfemalec, w, Sc_w)

    % compute mean_male = mean( sigmoid ( A_male * w - S_w ) )
    sigmoid_mean_male = mean( 1 ./ ( 1 + exp( Sc_w - Ac(idmalec,:)*w ) ) );
    % compute mean_female = mean( sigmoid ( A_female * w - S_w ) )
    sigmoid_mean_female = mean( 1 ./ ( 1 + exp( Sc_w - Ac(idfemalec,:)*w ) ) );
    % get the array of objective candidates abs( mean_male - mean_female ) 
    % then obtain the index of the largest one 
    [~, index] = max( abs( sigmoid_mean_male - sigmoid_mean_female ) );

    % compute the first part, sgn value, in the subgradient F'(w)
    sgn = sign( sigmoid_mean_male(1,index) - sigmoid_mean_female(1,index) );

    % based on this s, construct the second part in the subgradient F'(w)
    % compute derivative_male = Ac_male^T * ( sigmoid ./ (1 - sigmoid ) ) / nc_M
    sigmoid_male_s = 1 ./ ( 1 + exp( Sc_w(1,index) - Ac(idmalec,:)*w ) );
    subgrad_male = Ac(idmalec,:)' * ( sigmoid_male_s .* (1 - sigmoid_male_s) ) / nummalec;
    % compute derivative_female = Ac_female^T * ( sigmoid ./ (1 - sigmoid ) ) ) / nc_F
    sigmoid_female_s = 1 ./ ( 1 + exp( Sc_w(1,index) - Ac(idfemalec,:)*w ) );
    subgrad_female = Ac(idfemalec,:)' * ( sigmoid_female_s .* (1 - sigmoid_female_s) ) / numfemalec;

    % get the value of subgradient F'(w)
    subgrad = sgn * ( subgrad_male - subgrad_female );
end