import matplotlib.pyplot as plt

from active_ranking.experiments.experiment import Experiment, models
from active_ranking.experiments.plotting import plot
from active_ranking.scenarios import inputs

for k in inputs.__dict__.keys():
    from active_ranking import config

    if "scenario" in k:
        name = str(k)
        scenario = inputs.__dict__[name]
        j_max = scenario["j_max"]
        d = scenario["d"]
        e = scenario["eta"]
        n_max = scenario["n_max"]
        n_0 = scenario["n_0"]

        n_exp = 100
        experiments = [Experiment(m, n_exp, name) for m in models]
        for exp in experiments:
            exp.load()

        plt.figure(figsize=(4, 4), dpi=300)
        for exp in experiments:
            plot(exp, metric="inf_norm",
                 method="std",
                 kwargs_fill={"alpha": 0.0},
                 kwargs_plot={"label": exp.method.alg.name},
                 plot_stopping_time=True
                 )
        plt.axhline(config.epsilon, color="k", lw=0.5, label="$\\varepsilon$")
        plt.ylabel("$d_\infty$ regret")
        plt.xlabel("Number of sample")
        plt.xlim(exp.mean_n_sample.index.min(), exp.mean_n_sample.index.max())
        plt.legend()
        plt.tight_layout()
        plt.savefig(f"results/figures/analysis/epsilon/{name}_eps_dinf_regret")

        plt.figure(figsize=(4, 4), dpi=300)
        for exp in experiments:
            plot(exp, metric="one_norm",
                 method="std",
                 kwargs_fill={"alpha": 0.0},
                 kwargs_plot={"label": exp.method.alg.name},
                 plot_stopping_time=True
                 )
        plt.axhline(config.epsilon, color="k", lw=0.5, label="$\\varepsilon$")
        plt.xlabel("Number of sample")
        plt.legend()
        plt.ylabel("$d_1$ regret")
        plt.xlabel("Number of sample")
        plt.xlim(exp.mean_n_sample.index.min(), exp.mean_n_sample.index.max())
        plt.legend()
        plt.tight_layout()
        plt.savefig(f"results/figures/analysis/epsilon/{name}_d1_regret")
