from typing import Union, Type

from active_ranking.base.model import ActiveNaiveLeaner, DTrackingLearner
from active_ranking.base.model import PassiveLearner, ActiveLearnerOld, \
    ActiveLearner, ActiveClassificationLeaner, MessyRank
from active_ranking.scenarios import eta


class Scenario:
    """
    This class transform an algo as a callable function
    for testing purpose
    """

    def __init__(
            self,
            alg: Union[
                Type[PassiveLearner],
                Type[ActiveLearnerOld],
                Type[ActiveNaiveLeaner],
                Type[DTrackingLearner],
                Type[ActiveLearner],
                Type[ActiveClassificationLeaner],
                Type[MessyRank]
            ]):
        self.alg = alg

        self.name = self.alg.name

    def __call__(self, n_0, n_max, j_max, d, true_eta):
        e_ = eta.FunctionAsLabeler(true_eta)
        learner = self.alg(j_max=j_max, d=d, eta=e_)
        learner.add_tracker(true_eta)
        learner.run(n_0=n_0, n_max=n_max)
        return learner
