# Bipartite active  ranking


## Overview

Active ranking involves active selection of samples 
to be labeled by an oracle, with the intention of minimizing 
the number of queries needed to obtain accurate ranking. 

## Installation

In a python virtual environment, in the location of this current `readme` file, install the package using
```bash
pip install .
```

## Content
The content of the package is as followed 

* `active_ranking/base` contains all object useful for the algorithm
* `active_ranking/experiment` is a module allowing to repeat a very large number of time the scenarios
* `active_ranking/metrics` implements tools to compute regret 
* `active_ranking/scenarios` contains the data needed for the regression functions and the simulation parameters 
* `active_ranking/config` contains the constant use in our algorithm

## Usage
**Run all the simulation** Once the packages are installed, you can import and use the Active Ranking 
python `.\active_ranking\experiments\run.py`

:warning: Running all experiments can take some time (>1h on a 32-core computer)

```shell
python -m  active_ranking.experiments.run
```
To control the number of independent execution `n_exp`you can run 

```python
import matplotlib.pyplot as plt

from active_ranking.experiments.experiment import Experiment, models
from active_ranking.scenarios import inputs
from active_ranking.experiments.plotting import plot

if __name__ == '__main__':
    figure_args = dict(figsize=(3.5, 3.5), dpi=250)
    for k in inputs.__dict__.keys():
        if "scenario" in k:
            name = str(k)
            n_exp = 10  # To be modified according to
                        # the available computing time
            experiments = [Experiment(m, n_exp, name) for m in models]
            for exp in experiments:
                exp.run_or_load()

            plt.figure(**figure_args)
            for exp in experiments:
                plot(exp, metric="inf_norm", kwargs_fill={"alpha": 0.2},
                     kwargs_plot={"label": f"$d_\infty$ {exp.method.name}"})

            plt.ylabel("1 - $\\varepsilon$")
            plt.xlabel("$t$")
            plt.legend()
```
