from typing import Optional
import os
from .imagelist import PklImageList, PklImageListRG
from ._util import download as download_data, check_exits


class CarlaLoader(PklImageList):

    autodriv_image_list = {
        "9mdps_easy": "AutoDriv9mdps_easy.pkl",
        "9mdps_medium": "AutoDriv9mdps_medium.pkl",
        "9mdps_hard": "AutoDriv9mdps_hard.pkl",
        "2MDPs": "AutoDriv2MDPs.pkl",
    }

    CLASSES = ["car"]

    def __init__(self, root: str, task: str = "pair", download: Optional[bool] = False, **kwargs):
        if "AutoDriv" in root:
            image_list = self.autodriv_image_list
        else:
            raise NotImplementedError
        
        data_list_file = os.path.join(root, image_list[task])
        print(data_list_file)

        super(CarlaLoader, self).__init__(root, CarlaLoader.CLASSES, data_list_file=data_list_file, **kwargs)

    @classmethod
    def domains(cls):
        return list(cls.image_list.keys())