#!/bin/bash

# PARTIAL EVALUATION
list="SMDP1 SMDP2 SMDP3 SMDP4" # source env
# list="STMDP1 STMDP2 STMDP3 STMDP4 STMDP5 STMDP6 STMDP7 STMDP8 STMDP9 STMDP10" # seen target env
# list="UTMDP1 UTMDP2 UTMDP3 UTMDP4 UTMDP5 UTMDP6 UTMDP7 UTMDP8 UTMDP9 UTMDP10" # unseen target env

# list="SMDP1 SMDP2 SMDP3 SMDP4 SMDP5
# ST_RD_MDP1 ST_RD_MDP2 ST_RD_MDP3 ST_RD_MDP4 ST_RD_MDP5 ST_RD_MDP6 ST_RD_MDP7 ST_RD_MDP8 ST_RD_MDP9 
# ST_LT_MDP1 ST_LT_MDP2 ST_LT_MDP3 ST_LT_MDP4 ST_LT_MDP5 ST_LT_MDP6 ST_LT_MDP7 ST_LT_MDP8 ST_LT_MDP9 ST_LT_MDP10 
# ST_FV_MDP7 ST_FV_MDP8 ST_FV_MDP9 ST_FV_MDP10"
# list_split="5 9 10 4"

# TOTAL EVALUATION
list="
SMDP1 SMDP2 SMDP3 SMDP4
STMDP1 STMDP2 STMDP3 STMDP4 STMDP5 STMDP6 STMDP7 STMDP8 STMDP9 STMDP10
STMDP11 STMDP12 STMDP13 STMDP14 STMDP15 STMDP16 STMDP17 STMDP18 STMDP19 STMDP20
STMDP21 STMDP22 STMDP23 STMDP24 STMDP25 STMDP26 STMDP27 STMDP28 STMDP29 STMDP30
UTMDP1 UTMDP2 UTMDP3 UTMDP4 UTMDP5 UTMDP6 UTMDP7 UTMDP8 UTMDP9 UTMDP10
"
list_split="4 30 10"

# ANALYSIS
# list="ST_SS_MDP1 ST_SS_MDP2 ST_SS_MDP3 ST_SS_MDP4 ST_SS_MDP5 ST_SS_MDP6 ST_SS_MDP7 
# ST_RD_MDP1 ST_RD_MDP2 ST_RD_MDP3 ST_RD_MDP4 ST_RD_MDP5 ST_RD_MDP6 ST_RD_MDP7 ST_RD_MDP8 ST_RD_MDP9 
# ST_BR_MDP1 ST_BR_MDP2 ST_BR_MDP3 ST_BR_MDP4 ST_BR_MDP5 ST_BR_MDP6 ST_BR_MDP7 ST_BR_MDP8 ST_BR_MDP9 ST_BR_MDP10 
# ST_CT_MDP1 ST_CT_MDP2 ST_CT_MDP3 ST_CT_MDP4 ST_CT_MDP5 ST_CT_MDP6 ST_CT_MDP7 ST_CT_MDP8 ST_CT_MDP9 ST_CT_MDP10 
# ST_ST_MDP1 ST_ST_MDP2 ST_ST_MDP3 ST_ST_MDP4 ST_ST_MDP5 ST_ST_MDP6 ST_ST_MDP7 ST_ST_MDP8 ST_ST_MDP9 ST_ST_MDP10 
# ST_HU_MDP1 ST_HU_MDP2 ST_HU_MDP3 ST_HU_MDP4 ST_HU_MDP5 ST_HU_MDP6 ST_HU_MDP7 ST_HU_MDP8 ST_HU_MDP9 ST_HU_MDP10 
# ST_FV_MDP1 ST_FV_MDP2 ST_FV_MDP3 
# ST_FV_MDP4 ST_FV_MDP5 ST_FV_MDP6 
# ST_FV_MDP7 ST_FV_MDP8 ST_FV_MDP9 ST_FV_MDP10 ST_FV_MDP7 ST_FV_MDP7
# ST_LD_MDP1 ST_LD_MDP2 ST_LD_MDP3 ST_LD_MDP4 ST_LD_MDP5 ST_LD_MDP6 ST_LD_MDP7 ST_LD_MDP8 ST_LD_MDP9"
# list_split="7 9 10 10 10 10 3 3 6 9"

# ANALYSIS
# list="
# ST_FV_MDP1 ST_FV_MDP2 ST_FV_MDP3 
# ST_FV_MDP4 ST_FV_MDP5 ST_FV_MDP6 
# ST_FV_MDP7 ST_FV_MDP8 ST_FV_MDP9 ST_FV_MDP10 ST_FV_MDP7 ST_FV_MDP7"
# list_split="3 3 6"

timestamp=$(date +%s)
save_path="storage/experiment_output/"$timestamp
for var in $list
do
	export MDP=$var
	echo -e "\033[31m "${MDP} Test Start" \033[0m" 
	CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python allenact/main.py -o $save_path -b projects/object_navigation/baseline_configs/ithor $1 -c $2 --eval
	echo -e "\033[31m "${MDP} Test End" \033[0m"
	unset MDP
done

python eval.py --save-path $save_path --tag $1 --split-num $list_split
