import math
import numpy as np


def deg2rad(x):
    return x * np.pi/180

def getpos(r, h, theta):
    return np.array([r * np.cos(deg2rad(theta)), -r * np.sin(deg2rad(theta)), h])

def euler(camera_pos, object_pos):
    vector = object_pos - camera_pos
    r = np.linalg.norm(vector)
    #print(f"vector: {vector}, {r}")
    vector = np.absolute(vector)
    theta = np.arctan(vector[0]/vector[2])
    phi = np.arctan(vector[1]/vector[2])
    z = np.arcsin(vector[0]/r)
    if camera_pos[0] < 0 : z = z * -1; theta = theta * -1 
    return np.array([phi, theta, z+3.14])

#camera_pos = np.array([0.6, -0.6, 1.6])

np.set_printoptions(precision=3)
for i in range(5):
    degree = 0 + 45*i
    camera_pos = getpos(0.0, 1.4, degree)
    print(f"========= {i}-{degree} ===========")
    print(f"Camera Position: {camera_pos}")
    object_pos = np.array([0.0, 0.6, 0.0])
    eu = euler(camera_pos, object_pos)
    print(f"Euler Angle: {eu}\n")
